Attribute VB_Name = "mod_Common"
'This module contains various procedures that are used by more than
'one form in this 2510-AT demo program

Public Function CheckInput(value As Variant, Min As Single, Max As Single) As Single
'This routine compares the input Value for a variable to the Min and
'Max values.  If the input Value is greater/less than the max/min, this
'routine will coerce the value to the appropriate limit
'Inputs:    Value, Min, Max
'Outputs:   Range-bounded Function return

If Val(value) >= Min And Val(value) <= Max And value <> "" Then
    ElseIf value = "" Then value = Min      'If no value is entered, make the Value=min
            ElseIf Val(value) > Max Then
                value = Max
            ElseIf Val(value) < Min Then
                value = Min
 End If

CheckInput = Val(value)          'Set function return value to range-coerced value, val() converts string to numeric

End Function

Public Sub ReadStdRegister()
'Read the Standard Event Register (look for Autotune error)
'Read the Operational Event Register (look for Autotune successful)
'If error, read Error Queue based on user confirmation
'(reading of error queue clears error, which is undesirable if
'further data extraction is necessary for autotune troubleshooting)

Dim StdEventReg As Integer
Dim OperEventReg As Integer
Dim strErrorQueue As String
Dim strStdEventReg As String
Dim strOperEventReg As String
Dim geterror As Integer

If SendKI(intKI2510, "form:sreg asc") Then Exit Sub     'Format register returns to be ASCii
If SendKI(intKI2510, "*esr?") Then Exit Sub             'Query Std Event Register
'strStdEventReg = QueryKI(intKI2510)                   'Retrieve result
strStdEventReg = QueryKI(intKI2510)                   'Retrieve result
If SendKI(intKI2510, "stat:oper?") Then Exit Sub        'Query Operational Event Register
'strOperEventReg = QueryKI(intKI2510)                   'Retrieve result
strOperEventReg = QueryKI(intKI2510)                   'Retrieve result

'Look for bit x = 1
'StdEventReg = CInt(Right(strStdEventReg, 16))          'Strip off
'OperEventReg = CInt(Right(strOperEventReg, 16))
StdEventReg = CInt(strStdEventReg)
OperEventReg = CInt(strOperEventReg)

If StdEventReg And 16 Then         'Autotune quit with error
    geterror = MsgBox("The Autotune process was interrupted with an error. " & vbCrLf _
                & "Would you like to view the error code & title?" & vbCrLf & vbCrLf _
                & "(NOTE:  Choose NO if autotuning has failed repeatedly" & vbCrLf _
                & "             and futher troubleshooting is desired.)" & strErrorQueue, 52, "Error: Autotune did not complete")
    If geterror = vbYes Then
        If SendKI(intKI2510, "stat:que?") Then Exit Sub         'query Error queue
        strErrorQueue = QueryKI(intKI2510)                      'Retrieve result
        MsgBox "Autotune error:  " & strErrorQueue, vbExclamation, "Autotune Error"
    End If
    ElseIf OperEventReg And 128 Then 'Autotune successful
        MsgBox "Autotune successful"
        Call GetAllPIDData                                       'Get PID coefficients
        frmAutotune.txtMSETKp.Text = frmPIDCoeff.txtMSETKp
        frmAutotune.txtMSETKi.Text = frmPIDCoeff.txtMSETKi
        frmAutotune.txtMSETKd.Text = frmPIDCoeff.txtMSETKd
        frmAutotune.txtMOVKp.Text = frmPIDCoeff.txtMOVKp
        frmAutotune.txtMOVKi.Text = frmPIDCoeff.txtMOVKi
        frmAutotune.txtMOVKd.Text = frmPIDCoeff.txtMOVKd
        frmAutotune.cmdPIDStep.Enabled = True                     'Enable PIDStep button
End If

End Sub

Public Sub GetAllPIDData()
'Get the all 3 sets of PIDs (only in 2510-AT)
'1) Operational/present (currently programmed into instrument for PID temp control)
'2) Minimum Settle Time (MSET)
'3) Minimum OVershoot (MOV) PID coefficients
'then display

'Get presently used (i.e., current) PID coefficients
'get present Kp
Call SendKI(intKI2510, "sour:temp:lcon:gain?")
strpresKp = QueryKI(intKI2510)
frmPIDStep.txtKp.Text = Format(Val(strpresKp), "####0.0##")

'get present Ki
Call SendKI(intKI2510, "sour:temp:lcon:int?")
strpresKi = QueryKI(intKI2510)
frmPIDStep.txtKi.Text = Format(Val(strpresKi), "####0.0##")

'get present Kd
Call SendKI(intKI2510, "sour:temp:lcon:der?")
strpresKd = QueryKI(intKI2510)
frmPIDStep.txtKd.Text = Format(Val(strpresKd), "####0.0##")

'get MSET Kp
Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:gain?")
strMSETKp = QueryKI(intKI2510)
frmPIDCoeff.txtMSETKp.Text = Format(Val(strMSETKp), "####0.0##")

'get MSET Ki
Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:int?")
strMSETKi = QueryKI(intKI2510)
frmPIDCoeff.txtMSETKi.Text = Format(Val(strMSETKi), "####0.0##")

'get MSET Kd
Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:der?")
strMSETKd = QueryKI(intKI2510)
frmPIDCoeff.txtMSETKd.Text = Format(Val(strMSETKd), "####0.0##")

'get MOV (Minimum temp overshoot) values

'get MOV Kp
Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:gain?")
strMOVKp = QueryKI(intKI2510)
frmPIDCoeff.txtMOVKp.Text = Format(Val(strMOVKp), "####0.0##")

'get MOV Ki
Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:int?")
strMOVKi = QueryKI(intKI2510)
frmPIDCoeff.txtMOVKi.Text = Format(Val(strMOVKi), "####0.0##")

'get MOV Kd
Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:der?")
strMOVKd = QueryKI(intKI2510)
frmPIDCoeff.txtMOVKd.Text = Format(Val(strMOVKd), "####0.0##")

'ungray buttons if valid tuning numbers present
If Val(strMSETKp) <> 0 Then
    frmPIDStep.cmdGoToStartTemp.Enabled = True
End If


fino:
'ungray button

End Sub

Public Sub GetPresentPID()
'Retrieve "present" PID (values programmed for PID temp control)
'from instrument

'get present Kp
If SendKI(intKI2510, "sour:temp:lcon:gain?") Then Exit Sub
strpresKp = QueryKI(intKI2510)
frmPIDStep.txtKp.Text = Format(Val(strpresKp), "####0.0##")     'Update value on set PID form

'get present Ki
If SendKI(intKI2510, "sour:temp:lcon:int?") Then Exit Sub
strpresKi = QueryKI(intKI2510)
frmPIDStep.txtKi.Text = Format(Val(strpresKi), "####0.0##")

'get present Kd
If SendKI(intKI2510, "sour:temp:lcon:der?") Then Exit Sub
strpresKd = QueryKI(intKI2510)
frmPIDStep.txtKd.Text = Format(Val(strpresKd), "####0.0##")

frmPIDStep.Refresh                  'Make sure updated PIDs are displayed

End Sub


Public Sub Deriv_Info()
'Display brief explanation of Derivative term (Kd)

MsgBox "The Derivative gain term helps control the slew rate/dynamics of " & vbCrLf _
        & "the output response waveform.  Small values allow the temperature " & vbCrLf _
        & "to move as much and as fast as it would like where large values " & vbCrLf _
        & "control how fast things move.  Values that are too large will can " & vbCrLf _
        & "cause the system to go unstable.", vbInformation, "Kd - Derivative Gain Term"

End Sub

Public Sub Gain_Info()
'Display brief explanation of Proportional gain term (Kp)

MsgBox "Proportional term pushes the system to its final value.  " & vbCrLf _
        & "Lower numbers create a slower response where larger numbers " & vbCrLf _
        & "help increase the response speed.  Values too large will can " & vbCrLf _
        & "cause the system to oscillate and/or go unstable.", vbInformation, "Kp - Proportional Gain Term"

End Sub

Public Sub Integral_Info()
'Display brief explanation of Integral term (Ki)

MsgBox "The integral term is responsible for how fast the system settles" & vbCrLf _
        & "to its final value as well as how much overshoot there is in the" & vbCrLf _
        & "response.  Low numbers create a long settling tail with minimal " & vbCrLf _
        & "overshoot where large numbers settle much more quickly but with " & vbCrLf _
        & "larger overshoot.  Values too large will can cause to system to " & vbCrLf _
        & "go unstable (and most likely oscillate)", vbInformation, "Ki - Integral Gain Term"

End Sub
Public Sub Prep_Chart1()
'Configure Chart

With frmPIDStep.MSChart1
    .chartType = VtChChartType2dXY
    .ShowLegend = True
'    .Legend.Location.LocationType = VtChLocationTypeBottom          'Legend on bottom, instead of right side of chart
'   ShowLegend = False
    .Plot.Axis(VtChAxisIdY).AxisScale.Type = VtChScaleTypeLinear    'Set Y scale to linear
    .Plot.Axis(VtChAxisIdX).AxisScale.Type = VtChScaleTypeLinear    'Set X scale to linear
'    .Backdrop.Fill.Style = VtFillStyleBrush                    'Make background of chart (and surrounding area) white)
'    .Backdrop.Fill.Brush.Style = VtBrushStyleSolid             'Make background of chart (and surrounding area) white)
'    .Backdrop.Fill.Brush.FillColor.Set 255, 255, 255           'Make background of chart (and surrounding area) white)
    .Plot.Wall.Brush.Style = VtBrushStyleSolid                  'Make just chart/graph area background white


'Set number of data points
    .ColumnLabelCount = 2       'Two columns (1 X, 1 Y) required for each curve
    .ColumnCount = 4            'Two columns (1 X, 1 Y) required for each curve
    .RowCount = maxNumPoints        '# of data points
'    .ColumnCount = maxnumpoints            'Two columns (1 X, 1 Y) required for each curve

'Add data point markers
    .Plot.SeriesCollection(2).SeriesMarker.Show = ShowMarker 'Display data point markers
    .Plot.SeriesCollection(1).SeriesMarker.Show = ShowMarker 'Display data point markers
    .Plot.SeriesCollection.Item(1).SeriesMarker.Show = ShowMarker
    .Plot.SeriesCollection.Item(2).SeriesMarker.Show = ShowMarker

'Label Axes
    With .Plot.Axis(VtChAxisIdY).AxisTitle
        .VtFont.Size = 12
        .Visible = True
        .Text = "Temperature (C)"
    End With
    With .Plot.Axis(VtChAxisIdX).AxisTitle
        .VtFont.Size = 12
        .Visible = True
        .Text = "Elapsed Time (s)"
    End With

    .Plot.UniformAxis = False       'Tip from KB article Q194221:
    .Column = 1                     'First series (temp)
    .ColumnLabel = "Temperature"
'    .ColumnLabel = "Temperature, P= " & frmPIDStep.txtKp.Text & ", I= " & frmPIDStep.txtKi.Text & ", D= " & frmPIDStep.txtKd.Text
    .Column = 3                     'second series (temp setpoint)
    .ColumnLabel = "Setpoint"
End With



With frmPIDStep.MSChart1.DataGrid   'zero out data
    For i = 1 To maxNumPoints
    .SetData i, 1, 0, True          'Time Data
    .SetData i, 2, 0, True          'Temp data
    .SetData i, 3, 0, True          'Time data
    .SetData i, 4, 0, True          'Setpoint
    Next i
End With


'With MSChart1.DataGrid
'    For i = 1 To intSteps
'    .SetData i, intVolt, dblArray(intVolt, i), False
'    .SetData i, intCurr, dblArray(intCurr, i), False
'    Next i
'End With

End Sub

Public Sub Prep_Chart2()
'Configure Chart

With frmPIDStep.MSChart2
    .chartType = VtChChartType2dXY
    .ShowLegend = True
'    .Legend.Location.LocationType = VtChLocationTypeBottom          'Legend on bottom, instead of right side of chart
'   ShowLegend = False
    .Plot.Axis(VtChAxisIdY).AxisScale.Type = VtChScaleTypeLinear    'Set Y scale to linear
    .Plot.Axis(VtChAxisIdX).AxisScale.Type = VtChScaleTypeLinear    'Set X scale to linear
'    .Backdrop.Fill.Style = VtFillStyleBrush                    'Make background of chart (and surrounding area) white)
'    .Backdrop.Fill.Brush.Style = VtBrushStyleSolid             'Make background of chart (and surrounding area) white)
'    .Backdrop.Fill.Brush.FillColor.Set 255, 255, 255           'Make background of chart (and surrounding area) white)
    .Plot.Wall.Brush.Style = VtBrushStyleSolid                  'Make just chart/graph area background white


'Set number of data points
    .ColumnLabelCount = 2       'Two columns (1 X, 1 Y) required for each curve
    .ColumnCount = 4            'Two columns (1 X, 1 Y) required for each curve
    .RowCount = maxNumPoints        '# of data points
'    .ColumnCount = maxnumpoints            'Two columns (1 X, 1 Y) required for each curve

'Add data point markers
    .Plot.SeriesCollection(2).SeriesMarker.Show = ShowMarker 'Display data point markers
    .Plot.SeriesCollection(1).SeriesMarker.Show = ShowMarker 'Display data point markers
    .Plot.SeriesCollection.Item(1).SeriesMarker.Show = ShowMarker
    .Plot.SeriesCollection.Item(2).SeriesMarker.Show = ShowMarker

'Label Axes
    With .Plot.Axis(VtChAxisIdY).AxisTitle
        .VtFont.Size = 12
        .Visible = True
        .Text = "Temperature (C)"
    End With
    With .Plot.Axis(VtChAxisIdX).AxisTitle
        .VtFont.Size = 12
        .Visible = True
        .Text = "Elapsed Time (s)"
    End With

    .Plot.UniformAxis = False       'Tip from KB article Q194221:
    .Column = 1                     'First series (temp)
    .ColumnLabel = "Temperature"
    .Column = 3                     'second series (temp setpoint)
    .ColumnLabel = "Setpoint"
End With



With frmPIDStep.MSChart2.DataGrid   'zero out data
    For i = 1 To maxNumPoints
    .SetData i, 1, 0, True          'Time Data
'    .SetData i, 2, 0, True          'Temp data
    .SetData i, 3, 0, True          'Time data
'    .SetData i, 4, 0, True           'Setpoint
    Next i
End With


'With MSChart2.DataGrid
'    For i = 1 To intSteps
'    .SetData i, intVolt, dblArray(intVolt, i), False
'    .SetData i, intCurr, dblArray(intCurr, i), False
'    Next i
'End With

End Sub


Public Sub Config2510()
'This procedure configures the 2510 or 2510-AT:
'TEC protection (volt, curr, temp) and thermal tranducer type


'Set A/D sampling line frequency to minimize noise pickup
If SendKI(intKI2510, ":syst:lfr " & intLineFreq) Then Exit Sub

'Set temperature transducer type
If SendKI(intKI2510, ":sens:temp:tran " & strTempTrans) Then Exit Sub

'Set transducer range (thermistor) or type (RTD) & coefficients
If strTempTrans = "THER" Then
    If SendKI(intKI2510, ":sens:temp:ther:rang " & strRangeorType) Then Exit Sub
    If SendKI(intKI2510, ":sens:temp:ther:A " & frmAdvSettings.txtA.Text) Then Exit Sub    'Set Therm coeff
    If SendKI(intKI2510, ":sens:temp:ther:B " & frmAdvSettings.txtB.Text) Then Exit Sub    'Set Therm coeff
    If SendKI(intKI2510, ":sens:temp:ther:C " & frmAdvSettings.txtC.Text) Then Exit Sub    'Set Therm coeff
    ElseIf strTempTrans = "RTD" Then
        If SendKI(intKI2510, ":sens:temp:rtd:type " & strRangeorType) Then Exit Sub
        If strRangeorType = "USER" Then         'set RTD coeff if type=USER
            If SendKI(intKI2510, ":sens:temp:rtd:alph " & frmAdvSettings.txtAlpha.Text) Then Exit Sub    'Set RTD coeff
            If SendKI(intKI2510, ":sens:temp:rtd:beta " & frmAdvSettings.txtBeta.Text) Then Exit Sub    'Set RTD coeff
            If SendKI(intKI2510, ":sens:temp:rtd:delt " & frmAdvSettings.txtDelta.Text) Then Exit Sub    'Set RTD coeff
        End If
End If

'Set temperature sensor Auto current ON (default)
If SendKI(intKI2510, "sens:temp:curr:auto 1") Then Exit Sub

'Set protection values (V,I, temp)
If SendKI(intKI2510, ":SENS:CURR:PROT " & frmAdvSettings.txtCurrProt.Text) Then Exit Sub
If SendKI(intKI2510, ":SOUR1:VOLT:PROT " & frmAdvSettings.txtVoltProt.Text) Then Exit Sub
If SendKI(intKI2510, ":SOUR:TEMP:PROT " & frmAdvSettings.txtUppLim.Text) Then Exit Sub
If SendKI(intKI2510, ":SOUR:TEMP:PROT:LOW " & frmAdvSettings.txtLowLim.Text) Then Exit Sub

End Sub

Public Sub DUTTypeSettings(intType As Integer)
'This procedure sets parameters to appropriate values, depending
'on DUT type.
'Presently, only two DUT types: 1) Demo (for 2510 Demo DUT)
'                               2) Expert (no restrictions, user beware)

Select Case intType

Case 0                      'Unique, hard-coded, settings for the 2510 Demo TEC DUT
    'Set voltage, current and temperature protection
    frmAdvSettings.txtVoltProt = 0.85         'Set max voltage
    frmAdvSettings.txtCurrProt = 3.9         'Set max current
    frmAdvSettings.txtUppLim = 42          'Set upper temp limit
    frmAdvSettings.txtLowLim = 0           'Set lower temp limit
    frmAutotune.ATInstructions (0)   'Set instruction text for demo DUT
    
    'Disable TEC Protection Parameters & labels, to keep them from being "accidentally" changed
    frmAdvSettings.txtVoltProt.Enabled = False
    frmAdvSettings.lblVoltProt.Enabled = False
    frmAdvSettings.txtCurrProt.Enabled = False
    frmAdvSettings.lblCurrProt.Enabled = False
    frmAdvSettings.txtUppLim.Enabled = False
    frmAdvSettings.lblUppLim.Enabled = False
    frmAdvSettings.txtLowLim.Enabled = False
    frmAdvSettings.lblLowLim.Enabled = False

    'Set thermistor parameters, disable controls to lock-in values
    frmAdvSettings.optTempTrans(0).value = True     'Demo dut uses 10K thermistor
    frmAdvSettings.optTempTrans(0).Enabled = False  'Disable control
    frmAdvSettings.optTempTrans(1).Enabled = False  'Disable control
    frmAdvSettings.optThermRange(2).value = True    'Set default thermistor range - 10k
    frmAdvSettings.fraTherm.Enabled = False         'Disable frame

    'Set System Tau to short
    frmAutotune.optSysTau(0).value = True
    'Disable (lock) Sys Tau settings
    frmAutotune.optSysTau(0).Enabled = False
    frmAutotune.optSysTau(1).Enabled = False
    frmAutotune.optSysTau(2).Enabled = False
    
Case 1                  'Default settings for Expert Mode
    'Set voltage, current and temperature protection
    frmAdvSettings.txtVoltProt = 4         'Set max voltage
    frmAdvSettings.txtCurrProt = 2.5       'Set max current
    frmAdvSettings.txtUppLim = 50          'Set upper temp limit
    frmAdvSettings.txtLowLim = 0           'Set lower temp limit
'    strExpertInstr = "Set TEC Protection Parameters.  "     'Set extra instruction to blank for Demo mode
'    Form_Resize
    frmAutotune.ATInstructions (1)   'Set instruction text for Expert Mode
    'Enable TEC Protection Parameters
    frmAdvSettings.txtVoltProt.Enabled = True
    frmAdvSettings.lblVoltProt.Enabled = True
    frmAdvSettings.txtCurrProt.Enabled = True
    frmAdvSettings.lblCurrProt.Enabled = True
    frmAdvSettings.txtUppLim.Enabled = True
    frmAdvSettings.lblUppLim.Enabled = True
    frmAdvSettings.txtLowLim.Enabled = True
    frmAdvSettings.lblLowLim.Enabled = True

    'Set temperature resistor type and enable controls
    frmAdvSettings.optTempTrans(0).value = True     'Choose thermistor as default
    frmAdvSettings.optTempTrans(0).Enabled = True   'Enable control
    frmAdvSettings.optTempTrans(1).Enabled = True   'Enable control
    frmAdvSettings.fraTherm.Enabled = True          'Enable frame

    'Set Autotuning parameter controls
    'Set System Tau to short
    frmAutotune.optSysTau(0).value = True
    'Enable (unlock) Sys Tau settings
    frmAutotune.optSysTau(0).Enabled = True
    frmAutotune.optSysTau(1).Enabled = True
    frmAutotune.optSysTau(2).Enabled = True

    MsgBox "WARNING.  There is minimal parameter checking and control" & _
            vbCrLf & "                     in this mode.  It's possible to damage the TEC" & _
            vbCrLf & "                     and/or DUT. Please exercise caution.", vbExclamation, "Expert Mode WARNING"
    DoEvents            '(update screen)

End Select

End Sub
